﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Shared;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class SendPatientSideToEcStep : FilterBase<GetConsultsForPatientStateObject>
    {
        
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            //TODO, add in branching logic to either call the actual EC, or else the fake Ec Response (and remove the fake call from the create response).  Also add the fake failure as an option for the fake EcResponse depending on the value (usually we do 0 is success or 1 is failure)
            if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
            {

            }
            /*ToDo:
              1.  Call PatEcRequest.SendReceive:  See Pipeline Step 80 in MakeAppt folder)
              2.  Pipeline Step 98 - new method mapping EC back to LOB (the plugin)

              3. state.exception
            */
            try
            {
                var requestKvps = new List<KeyValuePair<string, VIMTVIAEMRgcfpgetConsultsForPatientRequest>>();
                requestKvps.Add(new KeyValuePair<string, VIMTVIAEMRgcfpgetConsultsForPatientRequest>("Pat", state.PatEcRequest));
                requestKvps.Add(new KeyValuePair<string, VIMTVIAEMRgcfpgetConsultsForPatientRequest>("Pro", state.ProEcRequest));

                Parallel.ForEach(requestKvps, request =>
                {
                    if (request.Key == "Pat" && state.PatEcRequest != null)
                        state.PatEcResponse = state.PatEcRequest.SendReceive<VIMTVIAEMRgcfpgetConsultsForPatientResponse>(MessageProcessType.Local);
                    if (request.Key == "Pro" && state.ProEcRequest != null)
                        state.ProEcResponse = state.ProEcRequest.SendReceive<VIMTVIAEMRgcfpgetConsultsForPatientResponse>(MessageProcessType.Local);
                });
            }
            catch (Exception ex)
            {
                state.ExceptionOccured = true;
                state.ExceptionMessage = PipelineUtilities.BuildErrorMessage(ex);
            }

        }
    }
}
